<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento       = $geecomDb->leggiSingolaRiga("geec_elementiLista",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_liste",$elemento["idLista"]);
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione elemento lista</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form action="controller/controllerComponente.php" method="post">
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento lista modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==220) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato, modificalo per non avere due elementi uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" name="operazione" value="modificaElemento">
                        <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                        <div class="col-lg-8 ">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Lista</a></li>
                                            <li class="breadcrumb-item"><a href="creaLista.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["nome"] : "Nuovo elemento"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="creaLista.php?id=<?php echo $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header py-3">
                                    <div class="row">
                                        <div class="form-group col-12">
                                            <label for="titolo-articolo">Nome</label>
                                            <input  type="text" class="form-control form-control-lg" name="nome" value="<?php echo((isset($elemento)? $elemento["nome"] : ""))?>" placeholder="Nome elemento">
                                        </div>
  
                                        <div class="form-group col-12">
                                            <label for="titolo-articolo">Classe elemento</label>
                                            <input  type="text" class="form-control form-control-lg" name="classeElemento" value="<?php echo((isset($elemento)? $elemento["classeElemento"] : ""))?>" placeholder="Classe elemento">
                                            <small>Aggiungi classi CSS per personalizzare questo elemento</small>
                                        </div>

                                    </div>
                                </div>

                                <div class="card-body wrapper-sezioni-pagina">
                                    <div class="my-4">
                                        <textarea name="descrizione" class="tiny"><?php echo(isset($elemento) ? $elemento["descrizione"] : "") ?></textarea>
                                    </div>

                                    <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                        </div><!--/Colonna principale -->
                        <!-- Colonna principale -->

                        <!--Colonna secondaria -->
                        <div class="col-lg-4  align-self-start sticky-top">
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                                <?php 
                                    if(isset($elemento)) {
                                ?>
                                        <button type="button" class="btn btn-warning w-100" onclick="location.href='controller/controllerComponente.php?id=<?php echo $elemento["idLista"] ?>&operazione=duplicaElemento&idElemento=<?php echo $elemento["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                <?php
                                    }
                                ?>
                            </div>

                            </form>
                        </div>
                    </form>

                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $elemento["Id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

        <script>
            function modificaImpostazioniSezione(id,idSezione,classeSezione,aTuttaLarghezza,margineSezione,paddindSezione) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value = idSezione;
                document.getElementById("classeSezione").value = classeSezione;
                document.getElementById("margineSezione").value = margineSezione;
                document.getElementById("paddingSezione").value = paddindSezione;

                if (typeof switchModalSezione !== 'undefined') {
                    switchModalSezione.destroy();
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "";

                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "<input type=\"checkbox\" id=\"sezioneATuttaLarghezza\" name=\"sezioneATuttaLarghezza\" value=\"si\" /><label>A tutta larghezza</label>";                    
                }

                var checkboxSezioneATuttaLarghezza = document.getElementById("sezioneATuttaLarghezza");
                if(aTuttaLarghezza==='si') {    
                    checkboxSezioneATuttaLarghezza.checked   = true;
                }
                checkboxSezioneATuttaLarghezza.className = "js-switch-modal";

                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });

                $('#modifica-impostazioni-sezione').modal('show');
            }

            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }

            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?php echo $elemento["Id"] ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?php echo $elemento["Id"] ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function aggiornaComponentiPagina() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        id:<?php echo $elemento["Id"] ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiContenuto").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }

            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();

                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Componente aggiornato con successo");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        id:<?php echo $elemento["Id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                location.href="../controller/controllerContenuti.php?id="+id+"&operazione=traduci&lingua="+l;
            }

            function eliminaPagina(id,titoloPagina) {
                $('#paginaDaEliminare').val(id);
                $('#nomePaginaDaEliminare').text(titoloPagina);
                $('#modalEliminaTraduzione').modal('show');
            }

            function eseguiEliminazionePagina() {
                var id = $('#paginaDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("pagina"+id).className = "d-none";
                            $('#modalEliminaTraduzione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
